@extends('layouts.user')
@section('content')
    <h2 class="title-bar no-border-bottom">
        {{$row->id ? __('Edit: ').$row->title : __('Add new seat')}}
        <div class="title-action">
            <a class="btn btn-info" href="{{route('flight.vendor.seat.index',['flight_id'=>$currentFlight->id])}}">
                <i class="fa fa-hand-o-right"></i> {{__("Manage Seats")}}
            </a>
        </div>
    </h2>
    @include('admin.message')
    <div class="lang-content-box">
        <form novalidate action="{{route('flight.vendor.seat.store',['flight_id'=>$currentFlight->id,'id'=>($row->id) ? $row->id : '-1','lang'=>request()->query('lang')])}}" class="needs-validation" method="post">
            @csrf
            <div class="form-add-service">
                <div class="nav nav-tabs nav-fill" id="nav-tab" role="tablist">
                    <a data-toggle="tab" href="#nav-tour-content" aria-selected="true" class="active">{{__("1. Seat Content")}}</a>
                </div>
                <div class="tab-content" id="nav-tabContent">
                    <div class="tab-pane fade show active" id="nav-tour-content">
                        @include('Flight::admin.flight.seat.form')
                    </div>
                </div>
            </div>
            <div class="d-flex justify-content-between">
                <button class="btn btn-primary btn_submit" type="submit"><i class="fa fa-save"></i> {{__('Save Changes')}}</button>
            </div>
        </form>
    </div>
@endsection
@push('js')
    <script type="text/javascript" src="{{ asset('libs/tinymce/js/tinymce/tinymce.min.js') }}" ></script>
    <script type="text/javascript" src="{{ asset('js/condition.js?_ver='.config('app.asset_version')) }}"></script>
    <script type="text/javascript" >
        jQuery(function ($) {
            "use strict"
            $(".btn_submit").on('click',function () {
                $(this).closest("form").submit();
            });
        });
    </script>
@endpush
